package demo.frame;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;

import java.awt.FlowLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

import netsdk.lib.*;
import netsdk.struct.*;

import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import demo.common.*;
import demo.module.DownLoadRecordModule;
import demo.module.LoginModule;
import demo.module.RealPlayModule;

import java.util.ArrayList;
import java.util.Date;
/*
 * 下载录像Demo
 */
class DownLoadRecordFrame extends JFrame{
	private JTabbedPane tabPane;//tab页控件
	
	//登录组件
	private LoginPanel loginPanel;
	// 搜索
	private searchRecordPanel _searchRecordPanel;
	private downloadPanel _downloadPanel;//下载
	private searchSetPanel _searchSetPanel;//搜索配置
	// 按时间搜索
	private String[] columnNameByTime = {"序号","通道","开始时间","结束时间"};
	private JPanel tablePanelByTime;
	private JTable tableByTime;
	private ArrayList<NET_SDK_REC_TIME> m_timeList;
	
	private SearchByTimePanel _searchByTimePanel; 
	private JPanel searchByFileSetPanel;
	private JPanel tablePanelByFile;
	//下载相关
	private JButton queryRecordBtn;
	private JButton downloadBtn;
	private JButton pathBrowse;
	private JTextField backUpPathTxt;
	private JFileChooser jfc;//路径选择
	private JProgressBar downloadProgressBar;


	private JTable tableByFile;
	private DefaultTableModel defaultmodel;
    private JLabel chnlabel;
    private JComboBox chnComboBoxByFile;	

    private JLabel streamLabel;
    private JComboBox streamComboBoxByFile;

    
    private DateChooserJButton dateChooserStartByFile;
    private DateChooserJButton dateChooserEndByFile;
	
	 // 按文件搜索
	private SearchByFilePanel _searchByFilePanel; 
	private JPanel searchByTimeSetPanel;

	
    private DateChooserJButton dateChooserStartByTime;
    private DateChooserJButton dateChooserEndByTime;
    
    private ArrayList<NET_SDK_REC_FILE> m_fileList;
    private Timer downloadTimer;//下载计时器
    private NativeLong m_ulDownloadstream;//下载句柄
	
    private JComboBox chnComboBoxOne;	
    private JComboBox streamComboBoxOne;
	
	private static final long serialVersionUID = 1L;
	private Vector<String> chnlist = new Vector<String>(); 
	
	private DefaultTableModel model;
	private NativeLong m_hDownLoadByTimeHandle = new NativeLong(0);   // 按时间下载句柄
	private NativeLong m_hDownLoadByFileHandle = new NativeLong(0);   // 按文件搜索句柄
	
	//按事件搜索
	//private JPanel 

    	
	// 开始时间
	private DD_TIME stTimeStart = new DD_TIME(); 
	
	// 结束时间
	private DD_TIME stTimeEnd = new DD_TIME();
	
	
	Object[][] data = null;
	
	// 获取界面窗口
	private static JFrame frame = new JFrame();   
	
	public DownLoadRecordFrame() {
	    setTitle(Res.string().getDownloadRecord());
	    setLayout(new BorderLayout());
	    pack();
	    setSize(800, 660);
	    setResizable(false);
	    setLocationRelativeTo(null);
		LoginModule.init();   // 打开工程，初始化
		
    	try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
        	e.printStackTrace();
        } 
        	    
	    loginPanel = new LoginPanel();
		_searchRecordPanel = new searchRecordPanel(); 
		_downloadPanel = new downloadPanel();
				
	    add(loginPanel, BorderLayout.NORTH);   
		add(_searchRecordPanel, BorderLayout.CENTER);
		add(_downloadPanel, BorderLayout.SOUTH);

	    loginPanel.addLoginBtnActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(loginPanel.checkLoginText()) {
					if(login()) {
						frame = ToolKits.getFrame(e);
						frame.setTitle(Res.string().getDownloadRecord() + " : " + Res.string().getOnline());
					}	
				}
			}
		});
	    
	    loginPanel.addLogoutBtnActionListener(new ActionListener() {		
			@Override
			public void actionPerformed(ActionEvent e) {
				frame.setTitle(Res.string().getDownloadRecord());
				logout();
			}
		});
	    
	    addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {
	    		LoginModule.netsdk.NET_SDK_StopGetFile(m_ulDownloadstream);
	    		LoginModule.logout();
	    		LoginModule.cleanup();   // 关闭工程，释放资源
	    		dispose();		
	    		
	    		SwingUtilities.invokeLater(new Runnable() {
	    			public void run() {
	    				FunctionList demo = new FunctionList();
	    				demo.setVisible(true);
	    			}
	    		});
	    	}
	    });
	}
		
	
	// 登录
	public boolean login() {
		if(LoginModule.login(loginPanel.ipTextArea.getText(), 
						Integer.parseInt(loginPanel.portTextArea.getText()), 
						loginPanel.nameTextArea.getText(), 
						new String(loginPanel.passwordTextArea.getPassword()))) {
	
			loginPanel.setButtonEnable(true);
			setButtonEnable(true);
			
			for(int i = 1; i < LoginModule.m_stDeviceInfo.videoInputNum + 1; i++) {
				chnlist.add(Res.string().getChannel() + " " + String.valueOf(i));
			}
			
			// 登陆成功，将通道添加到控件
	
			chnComboBoxByFile.setModel(new DefaultComboBoxModel(chnlist));
			
		} else {
			JOptionPane.showMessageDialog(null, Res.string().getLoginFailed() + ", " + ToolKits.getErrorCodeShow(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
			return false;
		}
		return true;
	}
	
	//登出
	public void logout() {
		LoginModule.logout();
		loginPanel.setButtonEnable(false);
		setButtonEnable(false);
	    
	    // 列表清空
		data = new Object[14][5];
		tableByFile.setModel(new DefaultTableModel(data, Res.string().getDownloadTableName()));
		tableByFile.getColumnModel().getColumn(0).setPreferredWidth(23);
		tableByFile.getColumnModel().getColumn(1).setPreferredWidth(28);
		tableByFile.getColumnModel().getColumn(2).setPreferredWidth(50);	
		
		// 列表清空
		data = new Object[14][4];		
		tableByTime.setModel(new DefaultTableModel(data, columnNameByTime));
		tableByTime.getColumnModel().getColumn(0).setPreferredWidth(23);
		tableByTime.getColumnModel().getColumn(1).setPreferredWidth(28);
		tableByTime.getColumnModel().getColumn(2).setPreferredWidth(50);
			
		for(int i = 0; i < LoginModule.m_stDeviceInfo.videoInputNum; i++) {
			chnlist.clear();
		}
		
		chnComboBoxByFile.setModel(new DefaultComboBoxModel());

		downloadBtn.setText(Res.string().getDownload());

	}
	/*
	 * 搜索配置面板
	 */
	private class searchSetPanel extends JPanel{
		public searchSetPanel() {
			/******** 设置面板***********/
			JPanel startTimeByFile = new JPanel();
			JPanel endTimeByFile = new JPanel();
			JPanel chnByFile = new JPanel();
			JPanel streamByFile = new JPanel();
			
			setLayout(new GridLayout(2, 2));
			
			add(startTimeByFile);
			add(endTimeByFile);
			add(chnByFile);
			add(streamByFile);
			
			// 开始时间设置
			startTimeByFile.setBorder(new EmptyBorder(5, 5, 5, 20));
			startTimeByFile.setLayout(new GridLayout(2, 1));
			JLabel startLabel = new JLabel(Res.string().getStartTime());
			dateChooserStartByFile = new DateChooserJButton();
			
			Dimension dimension = new Dimension();
			dimension.height = 20;
			dateChooserStartByFile.setPreferredSize(dimension);
			
			startTimeByFile.add(startLabel);
			startTimeByFile.add(dateChooserStartByFile);
		    
			// 结束时间设置
			endTimeByFile.setBorder(new EmptyBorder(5, 20, 5, 5));
			endTimeByFile.setLayout(new GridLayout(2, 1));
			JLabel endLabel = new JLabel(Res.string().getEndTime());
		    dateChooserEndByFile = new DateChooserJButton();
		    dateChooserEndByFile.setPreferredSize(dimension);
		    
		    endTimeByFile.add(endLabel);
		    endTimeByFile.add(dateChooserEndByFile);
		    
		    // 通道设置
		    chnByFile.setBorder(new EmptyBorder(5, 10, 0, 5));
		    chnByFile.setLayout(new FlowLayout());
			chnlabel = new JLabel(Res.string().getChannel());
			chnComboBoxByFile = new JComboBox();			
			chnComboBoxByFile.setPreferredSize(new Dimension(115, 20));  
			chnByFile.add(chnlabel);
			chnByFile.add(chnComboBoxByFile);
			
			// 码流设置
			streamByFile.setBorder(new EmptyBorder(5, 10, 0, 5));
			streamByFile.setLayout(new FlowLayout());
			streamLabel = new JLabel(Res.string().getStreamType());
			String[] stream = {Res.string().getMasterAndSub(), Res.string().getMasterStream(), Res.string().getSubStream()};
			streamComboBoxByFile = new JComboBox(stream);	
			streamComboBoxByFile.setModel(new DefaultComboBoxModel(stream));
			streamComboBoxByFile.setPreferredSize(new Dimension(115, 20));  
			streamByFile.add(streamLabel);
			streamByFile.add(streamComboBoxByFile);
			
			chnComboBoxByFile.setEnabled(false);
		    streamComboBoxByFile.setEnabled(false);
		    dateChooserStartByFile.setEnabled(false);
		    dateChooserEndByFile.setEnabled(false);
		  
		    streamComboBoxByFile.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent e) {
//					DownLoadRecordModule.setStreamType(streamComboBoxByFile.getSelectedIndex());
				}
			});
		}
		
	}
	/*
	 * 搜索录像面板
	 */
	private class searchRecordPanel extends JPanel {
		private static final long serialVersionUID = 1L;
		
		public searchRecordPanel() {
			BorderEx.set(this, "搜索录像", 2);
			setLayout(new BorderLayout());			
			_searchSetPanel = new searchSetPanel();//搜索配置
			add(_searchSetPanel, BorderLayout.NORTH);
			
			_searchByTimePanel = new SearchByTimePanel(); // 按时间下载
			_searchByFilePanel = new SearchByFilePanel();  // 按文件搜索						
		
			tabPane = new JTabbedPane();
			tabPane.addTab("按文件搜索", null, _searchByFilePanel, null);
			tabPane.addTab("按时间下载", null, _searchByTimePanel, null);
	        add(tabPane, BorderLayout.CENTER);
		}
	}
	/*
	 * 下载录像面板
	 */
	private class downloadPanel extends JPanel{
		public downloadPanel() {
			BorderEx.set(this, Res.string().getDownloadRecord(), 2);
			setLayout(new GridLayout(3,1));
			/******** 下载面板***********/		    
		    JPanel btnPanel = new JPanel();
		 // 查询、下载按钮
		    queryRecordBtn = new JButton(Res.string().getQuery());
		    downloadBtn = new JButton(Res.string().getDownload());    
		    
		    queryRecordBtn.setPreferredSize(new Dimension(175, 20)); 
		    downloadBtn.setPreferredSize(new Dimension(175, 20)); 
		    
		    //btnPanel.setLayout(new FlowLayout());
		    btnPanel.add(queryRecordBtn);
		    btnPanel.add(downloadBtn);
		    add(btnPanel);
		    		    
		    JPanel pathPanel = new JPanel();			
		    pathBrowse = new JButton(Res.string().getBrowseDownloadPath());
		    pathBrowse.setPreferredSize(new Dimension(105, 20)); 
		    pathPanel.add(pathBrowse);
		    
		    backUpPathTxt = new JTextField();
		    backUpPathTxt.setPreferredSize(new Dimension(245, 20)); 
		    pathPanel.add(backUpPathTxt);
		    add(pathPanel);
		    

		    downloadProgressBar = new JProgressBar(0, 100);		    
		    downloadProgressBar.setStringPainted(true);
		    add(downloadProgressBar);
		    		    		    		    										
		    
		    backUpPathTxt.setEnabled(false);
		    downloadProgressBar.setEnabled(false);
		    queryRecordBtn.setEnabled(false);
		    downloadBtn.setEnabled(false);
		    pathBrowse.setEnabled(false);
		    
		    pathBrowse.addActionListener(new ActionListener() {
		    	@Override
				public void actionPerformed(ActionEvent arg0) {
		    		jfc = new JFileChooser();
	        		jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY );  
	                if(jfc.showDialog(new JLabel(), "选择") == JFileChooser.APPROVE_OPTION) {
	                	File file = jfc.getSelectedFile();                
		                if(file.isDirectory()){  
		                    backUpPathTxt.setText(file.getAbsolutePath());
		                }
	                }
	                
		    	}
		    });
		    queryRecordBtn.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					int i = 1;//表格行数
					// 开始时间
					String[] dateStartByFile = dateChooserStartByFile.getText().split(" ");
					String[] dateStart1 = dateStartByFile[0].split("-");
					String[] dateStart2 = dateStartByFile[1].split(":");
											
					DD_TIME.ByReference stTimeStart = new DD_TIME.ByReference();
					stTimeStart.year = (short)(Short.parseShort(dateStart1[0]) - 1900);
					stTimeStart.month = (byte)(Byte.parseByte(dateStart1[1]) - 1);
					stTimeStart.mday = Byte.parseByte(dateStart1[2]);
					stTimeStart.hour = 0;
					stTimeStart.minute = 0;
					stTimeStart.second = 0;
					
					// 结束时间
					String[] dateEndByFile = dateChooserEndByFile.getText().split(" ");
					String[] dateEnd1 = dateEndByFile[0].split("-");
					String[] dateEnd2 = dateEndByFile[1].split(":");
					
					DD_TIME.ByReference stTimeEnd = new DD_TIME.ByReference();
					stTimeEnd.year = (short)(Short.parseShort(dateEnd1[0]) - 1900);
					stTimeEnd.month = (byte)(Byte.parseByte(dateEnd1[1]) - 1);
					stTimeEnd.mday = Byte.parseByte(dateEnd1[2]);
					stTimeEnd.hour = Byte.parseByte(dateEnd2[0]);
					stTimeEnd.minute = Byte.parseByte(dateEnd2[1]);
					stTimeEnd.second = Byte.parseByte(dateEnd2[2]);
//						
					if(stTimeStart.year != stTimeEnd.year
					   || stTimeStart.month != stTimeEnd.month
					   || (stTimeEnd.mday - stTimeStart.mday > 1)) {
						JOptionPane.showMessageDialog(null, Res.string().getSelectTimeAgain(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
						return;				
					}
					int selectedIndex = tabPane.getSelectedIndex();
					switch (selectedIndex){
					case 0://按文件搜索	
						i = 1;
						// 列表清空
						data = new Object[14][5];
						tableByFile.setModel(new DefaultTableModel(data, Res.string().getDownloadTableName()));
						tableByFile.getColumnModel().getColumn(0).setPreferredWidth(23);
						tableByFile.getColumnModel().getColumn(1).setPreferredWidth(28);
						tableByFile.getColumnModel().getColumn(2).setPreferredWidth(50);	 
						if(m_fileList!=null)
							m_fileList.clear();
						else
							m_fileList = new ArrayList<NET_SDK_REC_FILE>();
						
						int chnId = chnComboBoxByFile.getSelectedIndex();
						NativeLong fileHandle = LoginModule.netsdk.NET_SDK_FindFile(LoginModule.m_hLoginHandle, chnId, 
								stTimeStart,stTimeEnd);
						if(fileHandle.longValue() > 0) {										
							model = (DefaultTableModel)tableByFile.getModel();
							while(true) {
								NET_SDK_REC_FILE.ByReference stFileInfo = new NET_SDK_REC_FILE.ByReference();
								int result = LoginModule.netsdk.NET_SDK_FindNextFile(fileHandle, stFileInfo);
								if (result == 87) {
									break;
								}
								m_fileList.add(stFileInfo);
								model.setValueAt(i, i - 1, 0);
								model.setValueAt(String.valueOf(stFileInfo.dwChannel + 1), i - 1, 1);    // 设备返回的通道加1
								model.setValueAt(stFileInfo.dwRecType, i - 1, 2);
								model.setValueAt(stFileInfo.startTime.toString(), i - 1, 3);
								model.setValueAt(stFileInfo.stopTime.toString(), i - 1, 4);
								i++;
							}
						}														
						break;
					case 1://按时间搜索	
						i = 1;
						// 列表清空
						data = new Object[14][4];
						tableByTime.setModel(new DefaultTableModel(data, columnNameByTime));
						tableByTime.getColumnModel().getColumn(0).setPreferredWidth(23);
						tableByTime.getColumnModel().getColumn(1).setPreferredWidth(28);
						tableByTime.getColumnModel().getColumn(2).setPreferredWidth(50);
						if(m_timeList!=null)
							m_timeList.clear();
						else
							m_timeList = new ArrayList<NET_SDK_REC_TIME>();
							NativeLong byTimehandle = LoginModule.netsdk.NET_SDK_FindTime(LoginModule.m_hLoginHandle, chnComboBoxByFile.getSelectedIndex(), 
									stTimeStart,stTimeEnd);
							if(byTimehandle.longValue() > 0) {										
								model = (DefaultTableModel)tableByTime.getModel();
								while(true) {
									NET_SDK_REC_TIME.ByReference stTimeInfo = new NET_SDK_REC_TIME.ByReference();
									int result = LoginModule.netsdk.NET_SDK_FindNextTime(byTimehandle, stTimeInfo);
									if (result == 87) {
										break;
									}
									m_timeList.add(stTimeInfo);
									model.setValueAt(i, i - 1, 0);
									model.setValueAt(String.valueOf(stTimeInfo.dwChannel + 1), i - 1, 1);    // 设备返回的通道加1
									model.setValueAt(stTimeInfo.startTime.toString(), i - 1, 2);
									model.setValueAt(stTimeInfo.stopTime.toString(), i - 1, 3);
									i++;
								}
							}			
						break;
					}
										
				}	
			});
		  //备份进度条
	        downloadTimer = new Timer(1000, new ActionListener() {
	        	public void actionPerformed(ActionEvent e) {
	        		int nPos = LoginModule.netsdk.NET_SDK_GetDownloadPos(m_ulDownloadstream);
	        		if(nPos >=100 )
	        		{
	        			downloadTimer.stop();	
	        			LoginModule.netsdk.NET_SDK_StopGetFile(m_ulDownloadstream);
	        			if(LoginModule.m_hLoginHandle.intValue() > 0)//如果还是登录状态
	        				setButtonEnable(true);
	        		}
	        		downloadProgressBar.setValue(nPos);
	        	}
	        });
	        
	        //下载
	        downloadBtn.addActionListener(new ActionListener() {			
				@Override
				public void actionPerformed(ActionEvent e) {	
					int row = -1;
					int totalColumn = 0;//表格列数
					Date date = new Date();		
					String path = backUpPathTxt.getText();
					if(path.length() < 1) {
            			JOptionPane.showMessageDialog(null, "请选择备份路径", Res.string().getErrorMessage(), JOptionPane.WARNING_MESSAGE); 
            			return;
            		}
					String fileName = path + "Backup_" + date.getYear() + date.getMonth() + date.getDate() + 
							date.getHours() + date.getMinutes() + date.getSeconds()+ ".avi";
		            
					int m_streamType = streamComboBoxByFile.getSelectedIndex();

					m_ulDownloadstream = new NativeLong(-1);
					int tempChl = -1;
					DD_TIME tempStart = new DD_TIME();
					DD_TIME tempEnd = new DD_TIME();
					switch(tabPane.getSelectedIndex()) {
					case 0:
						model = (DefaultTableModel)tableByFile.getModel();
						row = tableByFile.getSelectedRow(); //获得所选的单行
						totalColumn = 5;
						break;
					case 1:
						model = (DefaultTableModel)tableByTime.getModel();
						row = tableByTime.getSelectedRow(); //获得所选的单行
						totalColumn = 4;
						break;
											
					}           		
					if(model == null) {
						JOptionPane.showMessageDialog(null, Res.string().getQueryRecord(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
						return;
					}
					
					if(row < 0) {
						JOptionPane.showMessageDialog(null, Res.string().getSelectRowWithData(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
						return;
					}
					
					for(int m = 1; m < totalColumn; m++) {
						if(model.getValueAt(row, m) == null || String.valueOf(model.getValueAt(row, m)).trim().equals("")) {
							JOptionPane.showMessageDialog(null, Res.string().getSelectRowWithData(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
							return;
						}
					}					
					switch(tabPane.getSelectedIndex()) {
					case 0:
						NET_SDK_REC_FILE tempFile = m_fileList.get(row);
						tempChl = tempFile.dwChannel;
						tempStart = tempFile.startTime;
						tempEnd = tempFile.stopTime;
						break;
					case 1:
						NET_SDK_REC_TIME tempTime = m_timeList.get(row);
						tempChl = tempTime.dwChannel;
						tempStart = tempTime.startTime;
						tempEnd = tempTime.stopTime;
					}															
					if( m_streamType == 0) {
						
						m_ulDownloadstream = LoginModule.netsdk.NET_SDK_GetFileByTimeEx(LoginModule.m_hLoginHandle, tempChl, tempStart, 
								tempEnd, fileName, false, false, null, null);
					}
					else {	//下载区分码流					
						m_ulDownloadstream = LoginModule.netsdk.NET_SDK_GetFileByTimeExV2(LoginModule.m_hLoginHandle, tempChl, tempStart, 
								tempEnd, fileName, (byte)0, m_streamType==1?true:false, false, null, null);
					}
					if(m_ulDownloadstream.longValue() == -1) {
						
					}
					else {
						downloadTimer.start();
						setButtonEnable(false);
					}					
					
						
				}			
			});
		}
	}
	/*
	 * 按文件搜索面板
	 */
	private class SearchByFilePanel extends JPanel {
		private static final long serialVersionUID = 1L;
		
		public SearchByFilePanel() {
			BorderEx.set(this, Res.string().getDownloadByFile(), 2);
			setLayout(new BorderLayout());

			tablePanelByFile = new JPanel(); // 查询						
			add(tablePanelByFile, BorderLayout.NORTH);
		    			
		    /******** 查询面板***********/
			tablePanelByFile.setLayout(new BorderLayout());
			tablePanelByFile.setBorder(new EmptyBorder(0, 5, 5, 5));
			
			data = new Object[14][5];
			defaultmodel = new DefaultTableModel(data, Res.string().getDownloadTableName());
			tableByFile = new JTable(defaultmodel){
				private static final long serialVersionUID = 1L;
				@Override
				public boolean isCellEditable(int row, int column) {
					return false;
				}
			};
			tableByFile.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);  // 只能选中一行	
			
			tableByFile.getColumnModel().getColumn(0).setPreferredWidth(15);
			tableByFile.getColumnModel().getColumn(1).setPreferredWidth(15);
			tableByFile.getColumnModel().getColumn(2).setPreferredWidth(50);
			
			DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
			dCellRenderer.setHorizontalAlignment(JLabel.CENTER);
			tableByFile.setDefaultRenderer(Object.class, dCellRenderer);
		    
			tablePanelByFile.add(new JScrollPane(tableByFile), BorderLayout.CENTER);	
			
			tableByFile.addMouseListener(new MouseAdapter(){
				public void mouseClicked(MouseEvent e) {
					if(e.getClickCount()==2){//点击几次，这里是双击事件
				        playBack();        
				       }
				}
			});
		    
		}
	}
	
	/*
	 * 按时间下载面板
	 */
	private class SearchByTimePanel extends JPanel {
		private static final long serialVersionUID = 1L;
		
		public SearchByTimePanel() {
			BorderEx.set(this, Res.string().getDownloadByTime(), 2);
			setLayout(new BorderLayout());
			

			 /******** 搜索结果面板***********/
			tablePanelByTime = new JPanel();
			tablePanelByTime.setLayout(new BorderLayout());
			tablePanelByTime.setBorder(new EmptyBorder(0, 5, 5, 5));
			
			data = new Object[14][4];
			defaultmodel = new DefaultTableModel(data, columnNameByTime);
			tableByTime = new JTable(defaultmodel){
				private static final long serialVersionUID = 1L;
				@Override
				public boolean isCellEditable(int row, int column) {
					return false;
				}
			};
			tableByTime.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);  // 可以选多行	
			
			tableByTime.getColumnModel().getColumn(0).setPreferredWidth(15);
			tableByTime.getColumnModel().getColumn(1).setPreferredWidth(15);
			tableByTime.getColumnModel().getColumn(2).setPreferredWidth(50);
			
			DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
			dCellRenderer.setHorizontalAlignment(JLabel.CENTER);
			tableByTime.setDefaultRenderer(Object.class, dCellRenderer);
		    
			tablePanelByTime.add(new JScrollPane(tableByTime), BorderLayout.CENTER);
			add(tablePanelByTime, BorderLayout.CENTER);
		}
		    		    
	}
		
	
	private void setButtonEnable(boolean bln) {
		//下载面板
		queryRecordBtn.setEnabled(bln);
		downloadBtn.setEnabled(bln);
		downloadProgressBar.setValue(0);
		downloadProgressBar.setEnabled(bln);
		pathBrowse.setEnabled(bln);
		//按文件搜索
		chnComboBoxByFile.setEnabled(bln);
		streamComboBoxByFile.setEnabled(bln);
		dateChooserStartByFile.setEnabled(bln);
		dateChooserEndByFile.setEnabled(bln);

	}
	private void playBack() {
		int row = -1;
		int totalColumn = 0;//表格列数
		
		int m_streamType = streamComboBoxByFile.getSelectedIndex();

		int tempChl = -1;
		DD_TIME tempStart = new DD_TIME();
		DD_TIME tempEnd = new DD_TIME();
		switch(tabPane.getSelectedIndex()) {
		case 0:
			model = (DefaultTableModel)tableByFile.getModel();
			row = tableByFile.getSelectedRow(); //获得所选的单行
			totalColumn = 5;
			break;
		case 1:
			model = (DefaultTableModel)tableByTime.getModel();
			row = tableByTime.getSelectedRow(); //获得所选的单行
			totalColumn = 4;
			break;								
		}  
		if(model == null) {
			JOptionPane.showMessageDialog(null, Res.string().getQueryRecord(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
			return;
		}		
		if(row < 0) {
			JOptionPane.showMessageDialog(null, Res.string().getSelectRowWithData(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		for(int m = 1; m < totalColumn; m++) {
			if(model.getValueAt(row, m) == null || String.valueOf(model.getValueAt(row, m)).trim().equals("")) {
				JOptionPane.showMessageDialog(null, Res.string().getSelectRowWithData(), Res.string().getErrorMessage(), JOptionPane.ERROR_MESSAGE);
				return;
			}
		}
		switch(tabPane.getSelectedIndex()) {
		case 0:
			NET_SDK_REC_FILE tempFile = m_fileList.get(row);
			tempChl = tempFile.dwChannel;
			tempStart = tempFile.startTime;
			tempEnd = tempFile.stopTime;
			break;
		case 1:
			NET_SDK_REC_TIME tempTime = m_timeList.get(row);
			tempChl = tempTime.dwChannel;
			tempStart = tempTime.startTime;
			tempEnd = tempTime.stopTime;
		}
		setVisible(false);
		PlayBackFrame pbf = new PlayBackFrame(LoginModule.m_hLoginHandle, tempStart, tempEnd, tempChl, this);
		pbf.setVisible(true);					
	}
				
}

public class DownLoadRecord {  
	public static void main(String[] args) {	
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				DownLoadRecordFrame demo = new DownLoadRecordFrame();
				demo.setVisible(true);
			}
		});		
	}
};

